@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('member.list_title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end">
									<form method="post" action="{{ route('member.index') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control"
												placeholder="{{ __('member.search') }}" required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th>{{ __('member.th_member') }}</th>
													<th class="nowrap">{{ __('member.th_reg_no') }}</th>
													<th class="nowrap">{{ __('member.th_name') }}</th>
													<th class="nowrap">{{ __('member.th_phone') }}</th>
													<th class="nowrap">{{ __('member.th_membership_type') }}</th>
													<th class="nowrap">{{ __('member.th_valid_from') }}</th>
													<th class="nowrap">{{ __('member.th_valid_to') }}</th>
													<th>{{ __('member.th_status') }}</th>
													<th class="fixed-width-td">{{ __('member.th_action') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($members as $member)
												<tr>
													<td class="align-middle">
														<div class="img-circle elevation-2 profile-image"
															style="background-image: url('{{ img_url($member->profile_picture) }}');">
														</div>
													</td>
													<td class="align-middle">{{ $member->reg_no }}</td>
													<td class="align-middle nowrap">{{ $member->name }}</td>
													<td class="align-middle nowrap">{{ $member->phone }}</td>
													<td class="align-middle nowrap">
														{{ isset($member->latest_membership->membership_type->name) ?
														$member->latest_membership->membership_type->name : '' }}
													</td>
													<td class="align-middle nowrap">
														{{ isset($member->latest_membership->valid_to) ?
														format_date($member->latest_membership->valid_from) : '' }}
													</td>
													<td class="align-middle nowrap">
														{{ isset($member->latest_membership->valid_to) ?
														format_date($member->latest_membership->valid_to) : '' }}
													</td>
													<td class="align-middle">
														{!! status_badge($member->status) !!}
													</td>
													<td>
														<div class="d-flex">
															<a href="{{ route('member.edit', $member->id) }}"
																type="button" class="btn btn-warning mr-2"><i
																	class="fa fa-edit"></i> </a>
															<form class="d-inline js-confirm-delete" method="POST"
																action="{{ route('member.destroy', $member->id) }}">
																{{ csrf_field() }}
																@method('DELETE')
																<button class="btn btn-danger">
																	<i class="fa fa-trash"></i>
																</button>
															</form>
														</div>
													</td>
												</tr>
												@endforeach
												@if(count($members) == 0)
												<tr>
													<td colspan="9">
														<p class="text-center mb-0">{{ __('member.no_record_found') }}
														</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $members->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection